--
-- This file is part of TALER
-- Copyright (C) 2025 Taler Systems SA
--
-- TALER is free software; you can redistribute it and/or modify it under the
-- terms of the GNU General Public License as published by the Free Software
-- Foundation; either version 3, or (at your option) any later version.
--
-- TALER is distributed in the hope that it will be useful, but WITHOUT ANY
-- WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
-- A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License along with
-- TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
--

SET search_path TO merchant;

DROP FUNCTION IF EXISTS merchant_do_update_product_group;
CREATE FUNCTION merchant_do_update_product_group (
  IN in_instance_id TEXT,
  IN in_product_group_serial TEXT,
  IN in_name TEXT,
  IN in_description TEXT,
  OUT out_conflict BOOL,
  OUT out_not_found BOOL)
LANGUAGE plpgsql
AS $$
DECLARE
  my_merchant_id INT8;
BEGIN

SELECT merchant_serial
  INTO my_merchant_id
  FROM merchant_instances
  WHERE merchant_id=in_instance_id;

BEGIN
  UPDATE merchant_product_groups SET
    product_group_name=in_name
   ,product_group_description=in_description
   WHERE merchant_serial=my_merchant_id
     AND product_group_serial=in_product_group_serial;
  out_not_found = NOT FOUND;
  out_conflict = FALSE;
  RETURN;
EXCEPTION
  WHEN unique_violation
  THEN
    out_conflict = TRUE;
    RETURN;
END;


END $$;
